IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CP_CD_ES_Rpt_Global_Ult_Accesos') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CP_CD_ES_Rpt_Global_Ult_Accesos
END
GO

CREATE PROCEDURE [dbo].[CP_CD_ES_Rpt_Global_Ult_Accesos] @pCantUltRegistros INT
AS
BEGIN
    SET NOCOUNT ON

    BEGIN TRY
        
        IF OBJECT_ID('tempdb..#rUlt_Accesos_Global') IS NOT NULL
            DROP TABLE #rUlt_Accesos_Global

        CREATE TABLE #rUlt_Accesos_Global (
            Id_ES           INT,
            Fecha           VARCHAR(10),
            Hora            VARCHAR(10),
            Tipo            VARCHAR(1),
            Id_Tarjeta      VARCHAR(50),
            Id_Cliente      INT,
            Razon_Social    VARCHAR(100),
            Resultado       VARCHAR(1),
            Observacion     VARCHAR(8000),
            Id_Controlador  SMALLINT,
            Controlador     VARCHAR(20),
            Id_Acceso       SMALLINT,
            Acceso          VARCHAR(20)
        )

        INSERT INTO #rUlt_Accesos_Global
        SELECT TOP (@pCantUltRegistros)
            CE.Id_ES,
            CONVERT(VARCHAR(10), CE.Fecha, 102) AS Fecha,
            CONVERT(VARCHAR(10), CE.Fecha, 108) AS Hora,
            CE.Tipo,
            CE.Id_Tarjeta,
            CE.Id_Cliente,
            CL.Razon_Social,
            CE.Resultado,
            CONVERT(VARCHAR(8000), CE.Observacion),
            CE.Id_Controlador,
            LEFT(CC.Descripcion, 20) AS Controlador,
            CE.Id_Acceso,
            CA.Descripcion AS Acceso
        FROM CD_ES CE
        INNER JOIN Clientes CL ON CE.Id_Cliente = CL.Id_Cliente
        INNER JOIN CD_Controladores CC ON CE.Id_Controlador = CC.Id_Controlador
        INNER JOIN CD_Accesos CA ON CE.Id_Acceso = CA.Id_Acceso
        WHERE CONVERT(DATE, CE.Fecha) = CONVERT(DATE, GETDATE())
        ORDER BY CE.Id_ES DESC

        SELECT * FROM #rUlt_Accesos_Global

        DROP TABLE #rUlt_Accesos_Global
    END TRY
    BEGIN CATCH
        -- Captura de error básica
        DECLARE @ErrorMessage NVARCHAR(4000) = ERROR_MESSAGE()
        RAISERROR('Error en el procedimiento CP_CD_ES_Rpt_Global_Ult_Accesos: %s', 16, 1, @ErrorMessage)
    END CATCH
END
GO
